#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//flowieMod01.fsh   by  Lumgol  
//https://www.shadertoy.com/view/XclfRf
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

const int numPetals = 5;
// must be greater than 0
const int numColors = 5;

// sdEgg from Inigo Quilez's website
float sdEgg( in vec2 p, in float he, in float ra, in float rb, vec2 up )
{
    float ce = 0.5*(he*he-(ra-rb)*(ra-rb))/(ra-rb);
    
    vec2 side = vec2(-up.y, up.x);
    vec2 newp = vec2(dot(p, side), dot(p, up) );
    newp.x = abs(newp.x);
    

    if( newp.y<0.0 )                return length(newp)-ra;
    if( newp.y*ce-newp.x*he>he*ce ) return length(vec2(newp.x,newp.y-he))-rb;
                                    return length(vec2(newp.x+ce,newp.y))-(ce+ra);
}

float largePetalOffset = 0.5;
float largePetalHe = 0.6;
float largePetalRadius1 = 0.3;

float smallPetalOffset = 0.3;
float smallPetalHe = 0.5;
float smallPetalRadius1 = 0.2;

float makeLargePetal(in vec2 uv, in float theta, in float swell) {
    vec2 up = vec2(cos(theta), sin(theta));
    float egg = sdEgg(uv - largePetalOffset * up, 
                      largePetalHe + swell, 
                      largePetalRadius1 + 0.3 * swell, 
                      0.02, 
                      up);
    float wiggle = 0.07 * cos(2. * float(numPetals) * atan(uv.y, uv.x));
    return egg+wiggle;
}

float makeSmallPetal(in vec2 uv, in float theta, in float swell) {
    theta += radians(360. / float(numPetals) / 2.);
    vec2 up = vec2(cos(theta), sin(theta));
    float egg = sdEgg(uv - smallPetalOffset * up, 
                      smallPetalHe + swell, 
                      smallPetalRadius1 + 0.3 * swell, 
                      0.02, 
                      up);
    float wiggle = 0.05 * cos(3. * float(numPetals) * atan(uv.y, uv.x));
    return egg + wiggle;
}


//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    // Normalized pixel coordinates (from -1 to 1)
    vec2 uv = (fragCoord*2. - iResolution.xy) / iResolution.y;
    vec2 uv2 = uv * 0.6;
    uv = 1.5 * uv;
    float checker = mod(floor(uv.x) + floor(uv.y), 2.);
    uv = 2.7*(fract(uv) - 0.5);
    
    float baseRotationSpeed  = (1./3.) * iTime;
    float largeRotationSpeed =           baseRotationSpeed + radians(180. * checker);
    float smallRotationSpeed = (5./3.) * baseRotationSpeed + radians(180. * checker);
    
    float swell = 0.4 * cos(5./3. * baseRotationSpeed) * (checker-0.5);
    float largeFlower = makeLargePetal(uv, 0. + largeRotationSpeed, swell);
    float smallFlower = makeSmallPetal(uv, 0. - smallRotationSpeed, swell);
    float hugeFlower = makeLargePetal(uv2, 0. + baseRotationSpeed, 0.);
    for (int i = 1; i < numPetals; i++) {
        float theta = radians(float(i) * (360. / float(numPetals)));
        largeFlower = min(largeFlower, 
                          makeLargePetal(uv, theta + largeRotationSpeed, swell));
        smallFlower = min(smallFlower, 
                          makeSmallPetal(uv, theta - smallRotationSpeed, swell));
        hugeFlower = min(hugeFlower, 
                         makeLargePetal(uv2, theta + baseRotationSpeed, 0.));
    }
    float largeFlowerStep = smoothstep(-0.02, 0.02, largeFlower);
    float smallFlowerStep = smoothstep(-0.06, 0.06, smallFlower);
    
    float largeRadius = largePetalOffset + largePetalHe + largePetalRadius1 + 0.02;
    float smallRadius = smallPetalOffset + 0.5 + 0.2 + 0.02;
    
    vec4 red    = vec4(0.7, 0.1, 0.4, 1.);
    vec4 orange = vec4(0.9, 0.4, 0.3, 1.);
    vec4 yellow = vec4(0.8, 0.8, 0.1, 1.);
    vec4 green  = vec4(0.1, 0.8, 0.2, 1.);
    vec4 blue   = vec4(0.3, 0.1, 0.9, 1.);
    vec4 purple = vec4(0.4, 0.2, 0.7, 1.);
    
    vec4[numColors] cols = vec4[numColors](orange, yellow, red, blue, purple);
    
    vec4 smallColor1 = checker < 0.5 ? cols[0]             : cols[4 % numColors];
    vec4 smallColor2 = checker < 0.5 ? cols[1 % numColors] : cols[5 % numColors];
    vec4 largeColor1 = checker < 0.5 ? cols[2 % numColors] : cols[6 % numColors];
    vec4 largeColor2 = checker < 0.5 ? cols[3 % numColors] : cols[7 % numColors];
    
    
    vec4 largeFlowerBlend = mix(largeColor1, largeColor2, 3. * abs(largeFlower));
    vec4 smallFlowerBlend = mix(smallColor1, smallColor2, 4. * abs(smallFlower));
    float mask = 1. - abs(hugeFlower);
    vec4 hugeFlowerBlend  = mix(purple, vec4(1.), 0.5*sin(30.*mask) + 0.5);
    vec4 tiling = mix(
                      (1. - largeFlowerStep) * largeFlowerBlend, 
                      (1. - smallFlowerStep) * smallFlowerBlend, 
                       1. - smallFlowerStep
                  );
    vec4 ghost = vec4(vec3(.8 - abs(hugeFlower)), 1.) * hugeFlowerBlend;
    ghost *= length(uv2) < 0.3 ? length(uv2) / 0.3 : 1.;
    
    fragColor = tiling.x + tiling.y + tiling.z >= 1.5 ? 2.*ghost*tiling : 1. - 2.*(1.-ghost)*(1.-tiling);
    // (1. - 2.*tiling) * ghost*ghost + 2.*ghost*tiling;
    //((tiling.x + tiling.y + tiling.z) >= 1.5 ? 2.*ghost*tiling : 1. - 2.*(1.-ghost)*(1.-tiling));
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

